function thetafinal = get_vectorfit(spot,ROI,parameters)
% This m-file is for fitting single emitter spots with a vector PSF model
% This includes standard 2D-fitting for xy, and extensions to 3D-fitting
% for xyz, and to xylambda and even to 4D-fitting for xyzlambda, and to
% aberration retrieval from through-focus stacks.
%

% (C) Copyright 2018
% All rights reserved
% Department of Imaging Physics
% Faculty of Applied Sciences
% Delft University of Technology
% Delft, The Netherlands   

parameters.Mx = ROI;
parameters.My = ROI;

parameters.xrange = parameters.pixelsize*parameters.Mx/2;
parameters.yrange = parameters.pixelsize*parameters.My/2;

allspots = spot((ceil(31/2)-floor(ROI/2):ceil(31/2)+floor(ROI/2)),(ceil(31/2)-floor(ROI/2):ceil(31/2)+floor(ROI/2)));

parameters.Ncfg = 1;

%%
% do MLE fit

% sampling coordinates in pupil plane and image plane
[XPupil,YPupil,XImage,YImage] = get_coords(parameters);

% estimation of initial values for the fit parameters, use initial values
% as starting point
thetainit = initialvalues(allspots,XImage,YImage,parameters);

% make MLE fit, parameters are max # of iterations, tolerance limit for
% the stopping criterion, the assumed read noise variance, and the
% optimizer type
parameters.Nitermax = 75;
parameters.tollim = 1e-6;
parameters.varfit = 0;
parameters.optmethod = 'levenbergmarquardt';
% parameters.optmethod = 'newtonraphson';

[thetastore,meritstore,Hessianstore,numiters] = localization(allspots,thetainit,parameters);
thetafinal = squeeze(thetastore(:,:,end));

% Fisher-matrix and CRLB computation, and chi-square computation
% plotrange indicates which fit results are plotted
% plotrange = 1:Ncfg;
Fisherstore = zeros(parameters.numparams,parameters.numparams,parameters.Ncfg);
CRLBstore = zeros(parameters.numparams,parameters.Ncfg);
chisquarestore = zeros(1,parameters.Ncfg);

for jcfg = 1:parameters.Ncfg
    theta = thetafinal(:,jcfg);
    parameters.xemit = theta(1);
    parameters.yemit = theta(2);
    Nph = theta(parameters.numparams-1);
    bg = theta(parameters.numparams);
    switch parameters.fitmodel
        case 'xyz'
            parameters.zemit = theta(3);
        case 'xylambda'
            parameters.lambda = theta(3);
        case 'xyzlambda'
            parameters.zemit = theta(3);
            parameters.lambda = theta(4);
        case 'aberrations'
            parameters.zemit = theta(3);
            parameters.aberrations(:,3) = theta(4:parameters.numparams-2);
    end
    parameters.signalphotoncount = Nph;
    parameters.backgroundphotoncount = bg;
    
    [~,~,wavevector,wavevectorzimm,Waberration,allzernikes,PupilMatrix] = get_pupil_matrix(parameters);
    [~,~,FieldMatrix,FieldMatrixDerivatives] = ...
        get_field_matrix_derivatives(PupilMatrix,wavevector,wavevectorzimm,Waberration,allzernikes,parameters);
    [allPSFs,PSFderivatives] = get_psfs_derivatives(FieldMatrix,FieldMatrixDerivatives,parameters);
    [Fisher,CRLB] = get_fisher_crlb(allPSFs,PSFderivatives,parameters);
    imagecfg = squeeze(allspots(:,:,:,jcfg));
    mucfg = Nph*allPSFs+bg;
    [chisquare,chisquaremean,chisquarestd] = get_chisquare(allPSFs,imagecfg,parameters);
    Fisherstore(:,:,jcfg) = Fisher;
    CRLBstore(:,jcfg) = CRLB;
    chisquarestore(jcfg) = chisquare;
end

% average over random instances
if parameters.Ncfg>1
    thetamean = mean(thetafinal,2);
    thetastd = std(thetafinal,1,2);
    thetastd(Nphindex) = std(thetafinal(Nphindex,:)-Nphtrue,1,2);
    thetastd(bgindex) = std(thetafinal(bgindex,:)-bgtrue,1,2);
    CRLBmean = mean(CRLBstore,2);
    CRLBstd = std(CRLBstore,1,2);
end
    
end


